/* FILE: mfile.h                                (D. Tottingham  12/27/89)

This is an include file of defines, data structure definitions and
external declarations that are common in the mfile module.

*/

#ifndef _MFILE_
#define _MFILE_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mbase36.h"
#include "mconst.h"
#include "suds.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define INDEX_FILENAME          "INDEX.@@@"
#define INDEX_FILESIZE          10

#define DAY                     0
#define MONTH                   1
#define YEAR                    2
#define HIGH                    3
#define LOW                     4

#define PATH_NAME               "C:"
#define NETWORK_NODE_ID         "M"
#define BLOCK_SIZE              4096

/* Event types */
#define F_CALIBRATION           'c'
#define F_EARTHQUAKE            'e'
#define F_FREERUN               'f'

/* Commands */
#define START_FILE              1
#define CONTINUE_FILE           2
#define END_FILE                3


/************************************************************************
                        STRUCTURE DEFINITIONS

The following structure definitions are included in here, so that all
modules can have access to them.

************************************************************************/
typedef struct {
        SUDS_STRUCTTAG structtag;
        SUDS_DETECTOR info;
} F_HEADER;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void f_check_pathname ();
PUBLIC long f_get_event_number ();
PUBLIC char * f_get_pathname ();
PUBLIC void f_initialize_index ();
PUBLIC void f_initialize_params ();
PUBLIC void f_set_pathname (char *);
PUBLIC void f_write_buffers (unsigned int, char);

#endif
